clear all;
clc;
close all;

LF=[250];
L=100;
%epsilon=[0.465:0.0025:0.49];
epsilon=[0.4725:0.0025:0.495];
epsilon=[0.46:0.0025:0.4775];
N=4;
Index_Code=3304;

Prob_error=zeros(length(LF),length(epsilon));
Prob_error_chain=zeros(N,length(epsilon));

Prob_error_BER=zeros(length(LF),length(epsilon));
Prob_error_chain_BER=zeros(N,length(epsilon));

nc=input('Variables_uncoupled_protograph?');

for m=1:1:length(LF)
    [~,~,CodName] = cod_string(Index_Code,LF(m),L,1,1);
    
    for e=1:1:length(epsilon)
        
        file=(['./Processed_Data/' CodName '_eps_' num2str(round(epsilon(e)*10000)) '.mat']);
        
        fid=fopen(file,'r');
        
        if(fid>-1)
            fclose(fid);
            
            load (file,'MatF');
            
            MatF(MatF<10)=0;
            
            Prob_error(m,e)=sum(sum(MatF)>5)/length(sum(MatF));
            
            Prob_error_BER(m,e)=sum(sum(MatF))/length(sum(MatF))/LF/L/N/nc;
            
            for u=1:1:N
                
                Prob_error_chain(u,e)=sum(MatF(u,:)>5)/length(MatF(u,:));
                
                Prob_error_chain_BER(u,e)=sum(MatF(u,:))/length(MatF(u,:))/LF/L/nc;
            end;
            
%             epsilon(e)
%             
%             sum(MatF>0)/length(MatF)
            
            
        end;
        
    end;
end;


savefile=(['./Error_Curves/' CodName '.mat']);

save(savefile,'LF','L','epsilon','Prob_error','N','Prob_error_chain','Prob_error_BER','Prob_error_chain_BER');

% semilogy(epsilon,Prob_error,'-*')
% 
% hold on
% figure(1);
% semilogy(epsilon,Prob_error_chain,'-*')
% xlabel('$\epsilon$','Interpreter','Latex');
% ylabel('Word Error Rate');
% legend('Layer 1', 'Layer 2', 'Layer 3', 'Layer 4');
% grid;
% hold on


figure(2);
% semilogy(epsilon,Prob_error_BER,'-*')
% 
semilogy(epsilon,Prob_error_chain_BER,'-*')
xlabel('$\epsilon$','Interpreter','Latex');
ylabel('Bit Error Rate');
legend('Layer 1', 'Layer 2', 'Layer 3', 'Layer 4');
grid;
hold on